package com.agilex.healthcare.directscheduling.domain.facility;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlAccessType ; 

import com.agilex.healthcare.directscheduling.domain.Namespace;

@XmlRootElement(name = "facility", namespace = Namespace.DirectScheduling)
@XmlAccessorType(value = XmlAccessType.NONE)
public class DSFacility {
		
	private String facilityParentSiteCode ; 
	private String facilityName ;
	private String facilityCode ; 
	private String facilityType ;  
	private String facilityCity  ; 
	private String facilityAddr1 ; 
	private String facilityAddr2 ;  
	private String facilityState  ;  
	
	private String patientICN ; 
	
	private Collection< DSFacilityClinic > facilityClinics ; 
	
	public DSFacility( ) { 
		
		facilityClinics = new ArrayList< DSFacilityClinic >( ) ;  
	}

	@XmlElement( name = "parentSiteCode" )
	public String getFacilityParentSiteCode() {
		return facilityParentSiteCode;
	}
	
	public void setFacilityParentSiteCode(String facilityParentSiteCode) {
		this.facilityParentSiteCode = facilityParentSiteCode;
	}
	
	@XmlElement
	public String getFacilityName() {
		return facilityName;
	}
	
	public void setFacilityName(String facilityName) {
		this.facilityName = facilityName;
	}  

	@XmlElement
	public String getFacilityType() {
		return facilityType;
	}

	public void setFacilityType(String facilityType) {
		this.facilityType = facilityType;
	}

	@XmlElement( name="clinicList" )
	public Collection<DSFacilityClinic> getFacilityClinics() {
		return facilityClinics;
	}

	public void setFacilityClinics(Collection<DSFacilityClinic> facilityClinics) {
		this.facilityClinics = facilityClinics;
	}

	@XmlElement
	public String getFacilityCode() {
		return facilityCode;
	}

	public void setFacilityCode(String facilityCode) {
		this.facilityCode = facilityCode;
	}

	@XmlElement
	public String getFacilityCity() {
		return facilityCity;
	}

	public void setFacilityCity(String facilityCity) {
		this.facilityCity = facilityCity;
	}

	@XmlElement
	public String getFacilityAddr1() {
		return facilityAddr1;
	}

	public void setFacilityAddr1(String facilityAddr1) {
		this.facilityAddr1 = facilityAddr1;
	}

	@XmlElement
	public String getFacilityAddr2() {
		return facilityAddr2;
	}

	public void setFacilityAddr2(String facilityAddr2) {
		this.facilityAddr2 = facilityAddr2;
	}

	@XmlElement
	public String getFacilityState() {
		return facilityState;
	}

	public void setFacilityState(String facilityState) {
		this.facilityState = facilityState;
	}

	@XmlElement
	public String getPatientICN() {
		return patientICN;
	}

	public void setPatientICN(String patientICN) {
		this.patientICN = patientICN;
	}

	public String toString( ) {
		
		StringBuffer sb = new StringBuffer( ) ;  
		sb.append( "facilityParentSiteCode=" ).append( facilityParentSiteCode ).append( "\t" ) ; 
		sb.append( "facilityName=" ).append( facilityName ) ;  	
		sb.append( "facilityCode=" ).append( facilityCode ) ; 
		
		return( sb.toString( ) ) ; 
	}
}
